#ifndef _MT7687_SDIO_H
#define _MT7687_SDIO_H

#include "iot_ctrl.h"

/* SPIS Command */
#define SPIS_H2D_TYPE_DATA (1<<0)
#define SPIS_H2D_TYPE_EVENT (1<<1)
    #define SPIS_CMD_GET_MAC 1
    #define SPIS_CMD_GET_MAC_ETH1 2	
    #define SPIS_CMD_GET_INFO_BUF_ADDR0 (SPIS_CMD_GET_MAC+1)
    #define SPIS_CMD_GET_INFO_BUF_ADDR7 (SPIS_CMD_GET_INFO_BUF_ADDR0+7)
	
    #define SPIS_CMD_GET_RD_BUF_ADDR (SPIS_CMD_GET_INFO_BUF_ADDR7+1)		// 0x0A
    #define SPIS_CMD_GET_WR_BUF_ADDR (SPIS_CMD_GET_RD_BUF_ADDR+1)	
    #define SPIS_CMD_GET_RXINFO (SPIS_CMD_GET_WR_BUF_ADDR+1)
    #define SPIS_CMD_SET_WIFI (SPIS_CMD_GET_RXINFO+1)

    #define SPIS_CMD_GET_LINK (SPIS_CMD_SET_WIFI+1)
    #define SPIS_CMD_GET_INFO (SPIS_CMD_GET_LINK +1)	

    #define SPIS_CMD_SET_POWER_OFF  0x10
    #define SPIS_CMD_SET_READ_DONE 	0x11
    #define SPIS_CMD_SET_RX_MODE 	0x12

	//For MT7682
    #define SPIS_CMD_ETH_PKT_TX 	0x13
    #define SDIO_CMD_ETH_2_PKT_TX 	0x14

	//Ethernet PKT Slave to Host	
    #define SPIS_CMD_GET_ETH_PKT 0x20
	

    #define SPIS_CMD_GET_INFO_ETH1 0x30


#define MT7682_SDIO_BLOCK_SIZE 256


//#define MAX_SPI_CMD_LEN SPIS_CFG_RD_CMD_LEN

	
//static u8 read_cmd_buf[MAX_SPI_CMD_LEN] = {0};


#define SDIO_SWINT_MB0_BROMSEND   0x00020000
	#define SDIO_SWINT_MB0_CMD_REQ_WIFI_INFO 1
	
#define SDIO_SWINT_MB0_BROMRECV   0x00010000
#define SDIO_SWINT_MB_SENDDATA    0x00020000
#define SDIO_SWINT_MB_RECVDATA    0x00010000
#define SDIO_SWINT_ERROR_BROMSEND 0x00080000
#define SDIO_SWINT_ERROR_BROMRECV 0x00040000

#define BROM_RX_Q0_PKT_CNT        (16)

#define BROM_RX_Q1_PKT_CNT        (16)

#define BROM_BLOCK_SIZE           (256)

//#define MAX_LOAD_SIZE             (352*1024)   //E1
#define MAX_LOAD_SIZE             (378*1024)   //E2
#define MAX_BLOCK_SIZE            (2048)

#define BROM_BUFF_SIZE            (4096)


#ifndef ALIGN_4
#define ALIGN_4(_value)             (((_value) + 3) & ~3u)
#endif /* ALIGN_4 */

//#define SLT_TEST_BLOCK_NUMBER  (7)
#define SLT_TEST_BLOCK_NUMBER  (8)

		 
		 typedef struct {
			 union {
				 struct {
					 uint32_t  tx_done_int: 1;
					 uint32_t  rx0_done_int: 1;
					 uint32_t  rx1_done_int: 1;
					 uint32_t  rx2_done_int: 1;
					 uint32_t  rx3_done_int: 1;
					 uint32_t  reserved: 1;
					 uint32_t  abnormal_int: 1;
					 uint32_t  fw_ownback_int: 1;
					 uint32_t  d2h_sw_int: 24;
				 } bits;
				 uint32_t		  asUINT32;
			 } u;
		 } sdio_whisr_t;
		 
		 
		 
		 typedef struct {
			 union {
				 struct {
					 uint32_t  tq0_cnt: 8;
					 uint32_t  tq1_cnt: 8;
					 uint32_t  tq2_cnt: 8;
					 uint32_t  tq3_cnt: 8;
				 } bits;
				 uint32_t		  asUINT32;
			 } u;
		 } sdio_wtsr0_t;
		 
		 
		 
		 typedef struct {
			 union {
				 struct {
					 uint32_t  tq4_cnt: 8;
					 uint32_t  tq5_cnt: 8;
					 uint32_t  tq6_cnt: 8;
					 uint32_t  tq7_cnt: 8;
				 } bits;
				 uint32_t		  asUINT32;
			 } u;
		 } sdio_wtsr1_t;
		
		 typedef struct {
			 sdio_whisr_t	 whisr ;
			 sdio_wtsr0_t	 whtsr0 ;
			 sdio_wtsr1_t	 whtsr1 ;
			 uint16_t  rx0_num ;
			 uint16_t  rx1_num ;
			 uint16_t  rx0_pkt_len[BROM_RX_Q0_PKT_CNT];
			 uint16_t  rx1_pkt_len[BROM_RX_Q1_PKT_CNT];
			 uint32_t	 d2hrm0r ;
			 uint32_t	 d2hrm1r ;
		 } sdio_whisr_enhance_t;



#ifndef ALIGN_TO_BLOCK_SIZE
#define ALIGN_TO_BLOCK_SIZE(_value)     (((_value) + (BROM_BLOCK_SIZE - 1)) & ~(BROM_BLOCK_SIZE - 1))
#endif
typedef struct {
    union {
        struct {
            uint32_t  length: 16;
            uint32_t  reserved: 13;
            uint32_t  tx_type: 3;
        } bits;
        uint32_t         asUINT32;
    } u;
} brom_sdio_tx_sdu_header_t;  // 4byte tx header
typedef struct {
    uint32_t  length: 16;
    uint32_t  reserved: 13;
    uint32_t  tx_type: 3;
} tx_header;

typedef struct {
    tx_header header;
    uint32_t *data;
} sdio_tx_data_t;  // 4byte tx header


/** @brief This enum defines the SDIO slave RX queue number. */
typedef enum {
    HAL_SDIO_SLAVE_RX_QUEUE_0 = 0,    /**< The SDIO slave RX queue 0. */
    HAL_SDIO_SLAVE_RX_QUEUE_1 = 1,    /**< The SDIO slave RX queue 1. */
    HAL_SDIO_SLAVE_RX_QUEUE_MAX
} hal_sdio_slave_rx_queue_id_t;
	

typedef struct  {
	u16   cmd;
	u16 pkt_len;
	u16 seq_num;		
	u16 reserve;
} iot_pkt_head_t;

#define TX_HEAD_SIZE			sizeof(iot_pkt_head_t)



#endif /* _MT7687_SPI_H */

